<?php

namespace App\Modules\HR\Entities;

use Illuminate\Database\Eloquent\Model;

class EmployeeJobInformation extends Model 
{

    protected $table = 'employee_job_informations';
    public $timestamps = true;
    protected $fillable = array('job_id', 'employee_number', 'contract_type', 'receiving_work_date', 'contract_period', 'salary');

    public function employee()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Employee');
    }

    public function job()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Job');
    }

    public function allowances()
    {
        return $this->belongsToMany('App\Modules\HR\Entities\Allowance');
    }

}